@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for the task that validates connection to PostgreSQL and source server requirements
 * @property sourceConnectionInfo Connection information for source PostgreSQL server
 */
public data class ConnectToSourcePostgreSqlSyncTaskInputResponse(
    public val sourceConnectionInfo: PostgreSqlConnectionInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourcePostgreSqlSyncTaskInputResponse): ConnectToSourcePostgreSqlSyncTaskInputResponse =
            ConnectToSourcePostgreSqlSyncTaskInputResponse(
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.PostgreSqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
