@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Input for the task that validates connection to SQL Server and also validates source server requirements
 * @property checkPermissionsGroup Permission group for validations
 * @property collectAgentJobs Flag for whether to collect agent jobs from source server.
 * @property collectDatabases Flag for whether to collect databases from source server.
 * @property collectLogins Flag for whether to collect logins from source server.
 * @property collectTdeCertificateInfo Flag for whether to collect TDE Certificate names from source server.
 * @property sourceConnectionInfo Connection information for Source SQL Server
 * @property validateSsisCatalogOnly Flag for whether to validate SSIS catalog is reachable on the source server.
 */
public data class ConnectToSourceSqlServerTaskInputResponse(
    public val checkPermissionsGroup: String? = null,
    public val collectAgentJobs: Boolean? = null,
    public val collectDatabases: Boolean? = null,
    public val collectLogins: Boolean? = null,
    public val collectTdeCertificateInfo: Boolean? = null,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val validateSsisCatalogOnly: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceSqlServerTaskInputResponse): ConnectToSourceSqlServerTaskInputResponse = ConnectToSourceSqlServerTaskInputResponse(
            checkPermissionsGroup = javaType.checkPermissionsGroup().map({ args0 -> args0 }).orElse(null),
            collectAgentJobs = javaType.collectAgentJobs().map({ args0 -> args0 }).orElse(null),
            collectDatabases = javaType.collectDatabases().map({ args0 -> args0 }).orElse(null),
            collectLogins = javaType.collectLogins().map({ args0 -> args0 }).orElse(null),
            collectTdeCertificateInfo = javaType.collectTdeCertificateInfo().map({ args0 ->
                args0
            }).orElse(null),
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            validateSsisCatalogOnly = javaType.validateSsisCatalogOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
