@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Agent Job level output for the task that validates connection to SQL Server and also validates source server requirements
 * @property id Result identifier
 * @property isEnabled The state of the original Agent Job.
 * @property jobCategory The type of Agent Job.
 * @property jobOwner The owner of the Agent Job
 * @property lastExecutedOn UTC Date and time when the Agent Job was last executed.
 * @property migrationEligibility Information about eligibility of agent job for migration.
 * @property name Agent Job name
 * @property resultType Type of result - database level or task level
 * Expected value is 'AgentJobLevelOutput'.
 * @property validationErrors Validation errors
 */
public data class ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse(
    public val id: String,
    public val isEnabled: Boolean,
    public val jobCategory: String,
    public val jobOwner: String,
    public val lastExecutedOn: String,
    public val migrationEligibility: MigrationEligibilityInfoResponse,
    public val name: String,
    public val resultType: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse): ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse =
            ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse(
                id = javaType.id(),
                isEnabled = javaType.isEnabled(),
                jobCategory = javaType.jobCategory(),
                jobOwner = javaType.jobOwner(),
                lastExecutedOn = javaType.lastExecutedOn(),
                migrationEligibility = javaType.migrationEligibility().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrationEligibilityInfoResponse.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
                resultType = javaType.resultType(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
