@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Database level output for the task that validates connection to SQL Server and also validates source server requirements
 * @property compatibilityLevel SQL Server compatibility level of database
 * @property databaseFiles The list of database files
 * @property databaseState State of the database
 * @property id Result identifier
 * @property name Database name
 * @property resultType Type of result - database level or task level
 * Expected value is 'DatabaseLevelOutput'.
 * @property sizeMB Size of the file in megabytes
 */
public data class ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse(
    public val compatibilityLevel: String,
    public val databaseFiles: List<DatabaseFileInfoResponse>,
    public val databaseState: String,
    public val id: String,
    public val name: String,
    public val resultType: String,
    public val sizeMB: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse): ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse =
            ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse(
                compatibilityLevel = javaType.compatibilityLevel(),
                databaseFiles = javaType.databaseFiles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseFileInfoResponse.Companion.toKotlin(args0)
                    })
                }),
                databaseState = javaType.databaseState(),
                id = javaType.id(),
                name = javaType.name(),
                resultType = javaType.resultType(),
                sizeMB = javaType.sizeMB(),
            )
    }
}
