@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Login level output for the task that validates connection to SQL Server and also validates source server requirements
 * @property defaultDatabase The default database for the login.
 * @property id Result identifier
 * @property isEnabled The state of the login.
 * @property loginType The type of login.
 * @property migrationEligibility Information about eligibility of login for migration.
 * @property name Login name.
 * @property resultType Type of result - database level or task level
 * Expected value is 'LoginLevelOutput'.
 */
public data class ConnectToSourceSqlServerTaskOutputLoginLevelResponse(
    public val defaultDatabase: String,
    public val id: String,
    public val isEnabled: Boolean,
    public val loginType: String,
    public val migrationEligibility: MigrationEligibilityInfoResponse,
    public val name: String,
    public val resultType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceSqlServerTaskOutputLoginLevelResponse): ConnectToSourceSqlServerTaskOutputLoginLevelResponse =
            ConnectToSourceSqlServerTaskOutputLoginLevelResponse(
                defaultDatabase = javaType.defaultDatabase(),
                id = javaType.id(),
                isEnabled = javaType.isEnabled(),
                loginType = javaType.loginType(),
                migrationEligibility = javaType.migrationEligibility().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrationEligibilityInfoResponse.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
                resultType = javaType.resultType(),
            )
    }
}
