@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Task level output for the task that validates connection to SQL Server and also validates source server requirements
 * @property agentJobs Source agent jobs as a map from agent job name to id.
 * @property databaseTdeCertificateMapping Mapping from database name to TDE certificate name, if applicable
 * @property databases Source databases as a map from database name to database id
 * @property id Result identifier
 * @property logins Source logins as a map from login name to login id.
 * @property resultType Type of result - database level or task level
 * Expected value is 'TaskLevelOutput'.
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerVersion Source server version
 * @property validationErrors Validation errors
 */
public data class ConnectToSourceSqlServerTaskOutputTaskLevelResponse(
    public val agentJobs: Map<String, String>,
    public val databaseTdeCertificateMapping: Map<String, String>,
    public val databases: Map<String, String>,
    public val id: String,
    public val logins: Map<String, String>,
    public val resultType: String,
    public val sourceServerBrandVersion: String,
    public val sourceServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceSqlServerTaskOutputTaskLevelResponse): ConnectToSourceSqlServerTaskOutputTaskLevelResponse =
            ConnectToSourceSqlServerTaskOutputTaskLevelResponse(
                agentJobs = javaType.agentJobs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                databaseTdeCertificateMapping = javaType.databaseTdeCertificateMapping().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                databases = javaType.databases().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                id = javaType.id(),
                logins = javaType.logins().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                resultType = javaType.resultType(),
                sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
                sourceServerVersion = javaType.sourceServerVersion(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
