@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates connection to Azure Database for PostgreSQL and target server requirements
 * @property databases List of databases on target server
 * @property id Result identifier
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Version of the target server
 * @property validationErrors Validation errors associated with the task
 */
public data class ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse(
    public val databases: List<String>,
    public val id: String,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse): ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse =
            ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse(
                databases = javaType.databases().map({ args0 -> args0 }),
                id = javaType.id(),
                targetServerBrandVersion = javaType.targetServerBrandVersion(),
                targetServerVersion = javaType.targetServerVersion(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
