@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates connection to Azure Database for PostgreSQL and target server requirements for Oracle source.
 * @property databaseSchemaMap Mapping of schemas per database
 * @property databases List of databases on target server
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Version of the target server
 * @property validationErrors Validation errors associated with the task
 */
public data class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputResponse(
    public val databaseSchemaMap: List<ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputResponseDatabaseSchemaMap>? =
        null,
    public val databases: List<String>,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputResponse): ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputResponse =
            ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputResponse(
                databaseSchemaMap = javaType.databaseSchemaMap().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputResponseDatabaseSchemaMap.Companion.toKotlin(args0)
                    })
                }),
                databases = javaType.databases().map({ args0 -> args0 }),
                targetServerBrandVersion = javaType.targetServerBrandVersion(),
                targetServerVersion = javaType.targetServerVersion(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
