@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates connection to Azure SQL Database Managed Instance.
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Target server version
 * @property validationErrors Validation errors
 */
public data class ConnectToTargetSqlMISyncTaskOutputResponse(
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlMISyncTaskOutputResponse): ConnectToTargetSqlMISyncTaskOutputResponse = ConnectToTargetSqlMISyncTaskOutputResponse(
            targetServerBrandVersion = javaType.targetServerBrandVersion(),
            targetServerVersion = javaType.targetServerVersion(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
