@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for the task that validates connection to Azure SQL DB and target server requirements
 * @property sourceConnectionInfo Connection information for source SQL Server
 * @property targetConnectionInfo Connection information for target SQL DB
 */
public data class ConnectToTargetSqlSqlDbSyncTaskInputResponse(
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlSqlDbSyncTaskInputResponse): ConnectToTargetSqlSqlDbSyncTaskInputResponse = ConnectToTargetSqlSqlDbSyncTaskInputResponse(
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
