@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Details on progress of ADF copy activity
 * @property copyDuration Copy Duration in seconds
 * @property copyStart Copy Start
 * @property copyThroughput Copy throughput in KBps
 * @property dataRead Bytes read
 * @property dataWritten Bytes written
 * @property parallelCopyType Type of parallel copy (Dynamic range, Physical partition, none).
 * @property rowsCopied Rows Copied
 * @property rowsRead Rows read
 * @property status Status of the Copy activity (InProgress, Succeeded, Failed, Canceled).
 * @property tableName Table Name
 * @property usedParallelCopies The degree of parallelization.
 */
public data class CopyProgressDetailsResponse(
    public val copyDuration: Int,
    public val copyStart: String,
    public val copyThroughput: Double,
    public val dataRead: Double,
    public val dataWritten: Double,
    public val parallelCopyType: String,
    public val rowsCopied: Double,
    public val rowsRead: Double,
    public val status: String,
    public val tableName: String,
    public val usedParallelCopies: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.CopyProgressDetailsResponse): CopyProgressDetailsResponse = CopyProgressDetailsResponse(
            copyDuration = javaType.copyDuration(),
            copyStart = javaType.copyStart(),
            copyThroughput = javaType.copyThroughput(),
            dataRead = javaType.dataRead(),
            dataWritten = javaType.dataWritten(),
            parallelCopyType = javaType.parallelCopyType(),
            rowsCopied = javaType.rowsCopied(),
            rowsRead = javaType.rowsRead(),
            status = javaType.status(),
            tableName = javaType.tableName(),
            usedParallelCopies = javaType.usedParallelCopies(),
        )
    }
}
