@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about backup files when existing backup mode is used.
 * @property backupFiles The list of backup files for the current database.
 * @property backupFinishDate Date and time when the backup operation finished.
 * @property backupType Backup Type.
 * @property databaseName Database name.
 * @property familyCount Number of files in the backup set.
 * @property isCompressed Whether the backup set is compressed
 * @property isDamaged Database was damaged when backed up, but the backup operation was requested to continue despite errors.
 * @property position Position of current database backup in the file.
 */
public data class DatabaseBackupInfoResponse(
    public val backupFiles: List<String>,
    public val backupFinishDate: String,
    public val backupType: String,
    public val databaseName: String,
    public val familyCount: Int,
    public val isCompressed: Boolean,
    public val isDamaged: Boolean,
    public val position: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.DatabaseBackupInfoResponse): DatabaseBackupInfoResponse = DatabaseBackupInfoResponse(
            backupFiles = javaType.backupFiles().map({ args0 -> args0 }),
            backupFinishDate = javaType.backupFinishDate(),
            backupType = javaType.backupType(),
            databaseName = javaType.databaseName(),
            familyCount = javaType.familyCount(),
            isCompressed = javaType.isCompressed(),
            isDamaged = javaType.isDamaged(),
            position = javaType.position(),
        )
    }
}
