@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Database Migration Resource properties for SQL database.
 * @property endedOn Database migration end time.
 * @property kind
 * Expected value is 'SqlDb'.
 * @property migrationFailureError Error details in case of migration failure.
 * @property migrationOperationId ID tracking current migration operation.
 * @property migrationService Resource Id of the Migration Service.
 * @property migrationStatus Migration status.
 * @property migrationStatusDetails Detailed migration status. Not included by default.
 * @property offlineConfiguration Offline configuration.
 * @property provisioningError Error message for migration provisioning failure, if any.
 * @property provisioningState Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started.
 * @property scope Resource Id of the target resource (SQL VM or SQL Managed Instance).
 * @property sourceDatabaseName Name of the source database.
 * @property sourceServerName Name of the source sql server.
 * @property sourceSqlConnection Source SQL Server connection details.
 * @property startedOn Database migration start time.
 * @property tableList List of tables to copy.
 * @property targetDatabaseCollation Database collation to be used for the target database.
 * @property targetSqlConnection Target SQL DB connection details.
 */
public data class DatabaseMigrationPropertiesSqlDbResponse(
    public val endedOn: String,
    public val kind: String,
    public val migrationFailureError: ErrorInfoResponse,
    public val migrationOperationId: String? = null,
    public val migrationService: String? = null,
    public val migrationStatus: String,
    public val migrationStatusDetails: SqlDbMigrationStatusDetailsResponse,
    public val offlineConfiguration: SqlDbOfflineConfigurationResponse,
    public val provisioningError: String? = null,
    public val provisioningState: String,
    public val scope: String? = null,
    public val sourceDatabaseName: String? = null,
    public val sourceServerName: String,
    public val sourceSqlConnection: SqlConnectionInformationResponse? = null,
    public val startedOn: String,
    public val tableList: List<String>? = null,
    public val targetDatabaseCollation: String? = null,
    public val targetSqlConnection: SqlConnectionInformationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.DatabaseMigrationPropertiesSqlDbResponse): DatabaseMigrationPropertiesSqlDbResponse = DatabaseMigrationPropertiesSqlDbResponse(
            endedOn = javaType.endedOn(),
            kind = javaType.kind(),
            migrationFailureError = javaType.migrationFailureError().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.ErrorInfoResponse.Companion.toKotlin(args0)
            }),
            migrationOperationId = javaType.migrationOperationId().map({ args0 -> args0 }).orElse(null),
            migrationService = javaType.migrationService().map({ args0 -> args0 }).orElse(null),
            migrationStatus = javaType.migrationStatus(),
            migrationStatusDetails = javaType.migrationStatusDetails().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlDbMigrationStatusDetailsResponse.Companion.toKotlin(args0)
            }),
            offlineConfiguration = javaType.offlineConfiguration().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlDbOfflineConfigurationResponse.Companion.toKotlin(args0)
            }),
            provisioningError = javaType.provisioningError().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sourceDatabaseName = javaType.sourceDatabaseName().map({ args0 -> args0 }).orElse(null),
            sourceServerName = javaType.sourceServerName(),
            sourceSqlConnection = javaType.sourceSqlConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startedOn = javaType.startedOn(),
            tableList = javaType.tableList().map({ args0 -> args0 }),
            targetDatabaseCollation = javaType.targetDatabaseCollation().map({ args0 -> args0 }).orElse(null),
            targetSqlConnection = javaType.targetSqlConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
