@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Description about the errors happen while performing migration validation
 * @property cpuTimeMs CPU Time in millisecond(s) for the query execution
 * @property elapsedTimeMs Time taken in millisecond(s) for executing the query
 * @property executionCount No. of query executions
 * @property hasErrors Indicates whether the query resulted in an error
 * @property sqlErrors List of sql Errors
 * @property waitStats Dictionary of sql query execution wait types and the respective statistics
 */
public data class ExecutionStatisticsResponse(
    public val cpuTimeMs: Double? = null,
    public val elapsedTimeMs: Double? = null,
    public val executionCount: Double? = null,
    public val hasErrors: Boolean? = null,
    public val sqlErrors: List<String>? = null,
    public val waitStats: Map<String, WaitStatisticsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ExecutionStatisticsResponse): ExecutionStatisticsResponse = ExecutionStatisticsResponse(
            cpuTimeMs = javaType.cpuTimeMs().map({ args0 -> args0 }).orElse(null),
            elapsedTimeMs = javaType.elapsedTimeMs().map({ args0 -> args0 }).orElse(null),
            executionCount = javaType.executionCount().map({ args0 -> args0 }).orElse(null),
            hasErrors = javaType.hasErrors().map({ args0 -> args0 }).orElse(null),
            sqlErrors = javaType.sqlErrors().map({ args0 -> args0 }),
            waitStats = javaType.waitStats().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.WaitStatisticsResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
