@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Database Migration Resource for Mongo to CosmosDb.
 * @property collectionList List of Mongo Collections to be migrated.
 * @property endedOn Database migration end time.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property kind
 * Expected value is 'MongoToCosmosDbMongo'.
 * @property migrationFailureError Error details in case of migration failure.
 * @property migrationOperationId ID for current migration operation.
 * @property migrationService Resource Id of the Migration Service.
 * @property migrationStatus Migration status.
 * @property name The name of the resource
 * @property provisioningError Error message for migration provisioning failure, if any.
 * @property provisioningState Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started.
 * @property scope Resource Id of the target resource.
 * @property sourceMongoConnection Source Mongo connection details.
 * @property startedOn Database migration start time.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property targetMongoConnection Target Cosmos DB Mongo connection details.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDatabaseMigrationsMongoToCosmosDbRUMongoResult(
    public val collectionList: List<MongoMigrationCollectionResponse>? = null,
    public val endedOn: String,
    public val id: String,
    public val kind: String,
    public val migrationFailureError: ErrorInfoResponse,
    public val migrationOperationId: String? = null,
    public val migrationService: String? = null,
    public val migrationStatus: String,
    public val name: String,
    public val provisioningError: String? = null,
    public val provisioningState: String,
    public val scope: String? = null,
    public val sourceMongoConnection: MongoConnectionInformationResponse? = null,
    public val startedOn: String,
    public val systemData: SystemDataResponse,
    public val targetMongoConnection: MongoConnectionInformationResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetDatabaseMigrationsMongoToCosmosDbRUMongoResult): GetDatabaseMigrationsMongoToCosmosDbRUMongoResult =
            GetDatabaseMigrationsMongoToCosmosDbRUMongoResult(
                collectionList = javaType.collectionList().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoMigrationCollectionResponse.Companion.toKotlin(args0)
                    })
                }),
                endedOn = javaType.endedOn(),
                id = javaType.id(),
                kind = javaType.kind(),
                migrationFailureError = javaType.migrationFailureError().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ErrorInfoResponse.Companion.toKotlin(args0)
                }),
                migrationOperationId = javaType.migrationOperationId().map({ args0 -> args0 }).orElse(null),
                migrationService = javaType.migrationService().map({ args0 -> args0 }).orElse(null),
                migrationStatus = javaType.migrationStatus(),
                name = javaType.name(),
                provisioningError = javaType.provisioningError().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
                sourceMongoConnection = javaType.sourceMongoConnection().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoConnectionInformationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                startedOn = javaType.startedOn(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                targetMongoConnection = javaType.targetMongoConnection().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoConnectionInformationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
