@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Database Migration Service resource
 * @property etag HTTP strong entity tag value. Ignored if submitted
 * @property id Resource ID.
 * @property kind The resource kind. Only 'vm' (the default) is supported.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The resource's provisioning state
 * @property publicKey The public key of the service, used to encrypt secrets sent to the service
 * @property sku Service SKU
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualNicId The ID of the Microsoft.Network/networkInterfaces resource which the service have
 * @property virtualSubnetId The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
 */
public data class GetServiceResult(
    public val etag: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val publicKey: String? = null,
    public val sku: ServiceSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNicId: String? = null,
    public val virtualSubnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicKey = javaType.publicKey().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ServiceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNicId = javaType.virtualNicId().map({ args0 -> args0 }).orElse(null),
            virtualSubnetId = javaType.virtualSubnetId(),
        )
    }
}
