@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that collects user tables for the given list of databases
 * @property selectedSourceDatabases List of source database names to collect tables for
 * @property selectedTargetDatabases List of target database names to collect tables for
 * @property sourceConnectionInfo Connection information for SQL Server
 * @property targetConnectionInfo Connection information for SQL DB
 */
public data class GetUserTablesSqlSyncTaskInputResponse(
    public val selectedSourceDatabases: List<String>,
    public val selectedTargetDatabases: List<String>,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesSqlSyncTaskInputResponse): GetUserTablesSqlSyncTaskInputResponse = GetUserTablesSqlSyncTaskInputResponse(
            selectedSourceDatabases = javaType.selectedSourceDatabases().map({ args0 -> args0 }),
            selectedTargetDatabases = javaType.selectedTargetDatabases().map({ args0 -> args0 }),
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
