@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Output of the task that collects user tables for the given list of databases
 * @property databasesToSourceTables Mapping from database name to list of source tables
 * @property databasesToTargetTables Mapping from database name to list of target tables
 * @property tableValidationErrors Mapping from database name to list of validation errors
 * @property validationErrors Validation errors
 */
public data class GetUserTablesSqlSyncTaskOutputResponse(
    public val databasesToSourceTables: Map<String, List<DatabaseTableResponse>>,
    public val databasesToTargetTables: Map<String, List<DatabaseTableResponse>>,
    public val tableValidationErrors: Map<String, List<String>>,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesSqlSyncTaskOutputResponse): GetUserTablesSqlSyncTaskOutputResponse = GetUserTablesSqlSyncTaskOutputResponse(
            databasesToSourceTables = javaType.databasesToSourceTables().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseTableResponse.Companion.toKotlin(args0)
                        })
                    }),
                )
            }).toMap(),
            databasesToTargetTables = javaType.databasesToTargetTables().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseTableResponse.Companion.toKotlin(args0)
                        })
                    }),
                )
            }).toMap(),
            tableValidationErrors = javaType.tableValidationErrors().map({ args0 ->
                args0.key.to(args0.value.map({ args0 -> args0 }))
            }).toMap(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
