@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that collects user tables for the given list of databases
 * @property connectionInfo Connection information for SQL Server
 * @property selectedDatabases List of database names to collect tables for
 */
public data class GetUserTablesSqlTaskInputResponse(
    public val connectionInfo: SqlConnectionInfoResponse,
    public val selectedDatabases: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesSqlTaskInputResponse): GetUserTablesSqlTaskInputResponse = GetUserTablesSqlTaskInputResponse(
            connectionInfo = javaType.connectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            selectedDatabases = javaType.selectedDatabases().map({ args0 -> args0 }),
        )
    }
}
