@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Integration Runtime Monitoring Data.
 * @property name The name of Integration Runtime.
 * @property nodes Integration Runtime node monitoring data.
 */
public data class ListSqlMigrationServiceMonitoringDataResult(
    public val name: String,
    public val nodes: List<NodeMonitoringDataResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ListSqlMigrationServiceMonitoringDataResult): ListSqlMigrationServiceMonitoringDataResult = ListSqlMigrationServiceMonitoringDataResult(
            name = javaType.name(),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.NodeMonitoringDataResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
