@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for command that completes online migration for an Azure SQL Database Managed Instance.
 * @property errors List of errors that happened during the command execution
 */
public data class MigrateMISyncCompleteCommandOutputResponse(
    public val errors: List<ReportableExceptionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMISyncCompleteCommandOutputResponse): MigrateMISyncCompleteCommandOutputResponse = MigrateMISyncCompleteCommandOutputResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
