@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties for the command that completes online migration for an Azure SQL Database Managed Instance.
 * @property commandType Command type.
 * Expected value is 'Migrate.SqlServer.AzureDbSqlMi.Complete'.
 * @property errors Array of errors. This is ignored if submitted.
 * @property input Command input
 * @property output Command output. This is ignored if submitted.
 * @property state The state of the command. This is ignored if submitted.
 */
public data class MigrateMISyncCompleteCommandPropertiesResponse(
    public val commandType: String,
    public val errors: List<ODataErrorResponse>,
    public val input: MigrateMISyncCompleteCommandInputResponse? = null,
    public val output: MigrateMISyncCompleteCommandOutputResponse,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMISyncCompleteCommandPropertiesResponse): MigrateMISyncCompleteCommandPropertiesResponse =
            MigrateMISyncCompleteCommandPropertiesResponse(
                commandType = javaType.commandType(),
                errors = javaType.errors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ODataErrorResponse.Companion.toKotlin(args0)
                    })
                }),
                input = javaType.input().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateMISyncCompleteCommandInputResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                output = javaType.output().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateMISyncCompleteCommandOutputResponse.Companion.toKotlin(args0)
                }),
                state = javaType.state(),
            )
    }
}
