@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Database specific information for offline MySQL to Azure Database for MySQL migration task inputs
 * @property name Name of the database
 * @property tableMap Mapping of source to target tables
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 */
public data class MigrateMySqlAzureDbForMySqlOfflineDatabaseInputResponse(
    public val name: String? = null,
    public val tableMap: Map<String, String>? = null,
    public val targetDatabaseName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlOfflineDatabaseInputResponse): MigrateMySqlAzureDbForMySqlOfflineDatabaseInputResponse =
            MigrateMySqlAzureDbForMySqlOfflineDatabaseInputResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                tableMap = javaType.tableMap().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                targetDatabaseName = javaType.targetDatabaseName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
