@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property databaseName Name of the database
 * @property endedOn Migration end time
 * @property errorCount Number of database/object errors.
 * @property errorPrefix Wildcard string prefix to use for querying all errors of the item
 * @property exceptionsAndWarnings Migration exceptions and warnings.
 * @property id Result identifier
 * @property lastStorageUpdate Last time the storage was updated
 * @property message Migration progress message
 * @property numberOfObjects Number of objects
 * @property numberOfObjectsCompleted Number of successfully completed objects
 * @property objectSummary Summary of object results in the migration
 * @property resultPrefix Wildcard string prefix to use for querying all sub-tem results of the item
 * @property resultType Result type
 * Expected value is 'DatabaseLevelOutput'.
 * @property stage Migration stage that this database is in
 * @property startedOn Migration start time
 * @property state Current state of migration
 * @property statusMessage Status message
 */
public data class MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevelResponse(
    public val databaseName: String,
    public val endedOn: String,
    public val errorCount: Double,
    public val errorPrefix: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val lastStorageUpdate: String,
    public val message: String,
    public val numberOfObjects: Double,
    public val numberOfObjectsCompleted: Double,
    public val objectSummary: Map<String, DataItemMigrationSummaryResultResponse>,
    public val resultPrefix: String,
    public val resultType: String,
    public val stage: String,
    public val startedOn: String,
    public val state: String,
    public val statusMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevelResponse): MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevelResponse =
            MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevelResponse(
                databaseName = javaType.databaseName(),
                endedOn = javaType.endedOn(),
                errorCount = javaType.errorCount(),
                errorPrefix = javaType.errorPrefix(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                lastStorageUpdate = javaType.lastStorageUpdate(),
                message = javaType.message(),
                numberOfObjects = javaType.numberOfObjects(),
                numberOfObjectsCompleted = javaType.numberOfObjectsCompleted(),
                objectSummary = javaType.objectSummary().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.DataItemMigrationSummaryResultResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                resultPrefix = javaType.resultPrefix(),
                resultType = javaType.resultType(),
                stage = javaType.stage(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
                statusMessage = javaType.statusMessage(),
            )
    }
}
