@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property databaseSummary Summary of database results in the migration
 * @property databases Selected databases as a map from database name to database id
 * @property durationInSeconds Duration of task execution in seconds.
 * @property endedOn Migration end time
 * @property exceptionsAndWarnings Migration exceptions and warnings.
 * @property id Result identifier
 * @property lastStorageUpdate Last time the storage was updated
 * @property message Migration progress message
 * @property migrationReportResult Migration Report Result, provides unique url for downloading your migration report.
 * @property resultType Result type
 * Expected value is 'MigrationLevelOutput'.
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerVersion Source server version
 * @property startedOn Migration start time
 * @property status Current status of migration
 * @property statusMessage Migration status message
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Target server version
 */
public data class MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevelResponse(
    public val databaseSummary: Map<String, DatabaseSummaryResultResponse>,
    public val databases: Map<String, String>? = null,
    public val durationInSeconds: Double,
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val lastStorageUpdate: String,
    public val message: String,
    public val migrationReportResult: MigrationReportResultResponse? = null,
    public val resultType: String,
    public val sourceServerBrandVersion: String,
    public val sourceServerVersion: String,
    public val startedOn: String,
    public val status: String,
    public val statusMessage: String,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevelResponse): MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevelResponse =
            MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevelResponse(
                databaseSummary = javaType.databaseSummary().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseSummaryResultResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                databases = javaType.databases().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                durationInSeconds = javaType.durationInSeconds(),
                endedOn = javaType.endedOn(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                lastStorageUpdate = javaType.lastStorageUpdate(),
                message = javaType.message(),
                migrationReportResult = javaType.migrationReportResult().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrationReportResultResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                resultType = javaType.resultType(),
                sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
                sourceServerVersion = javaType.sourceServerVersion(),
                startedOn = javaType.startedOn(),
                status = javaType.status(),
                statusMessage = javaType.statusMessage(),
                targetServerBrandVersion = javaType.targetServerBrandVersion(),
                targetServerVersion = javaType.targetServerVersion(),
            )
    }
}
