@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source MySQL
 * @property targetConnectionInfo Connection information for target Azure Database for MySQL
 */
public data class MigrateMySqlAzureDbForMySqlSyncTaskInputResponse(
    public val selectedDatabases: List<MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse>,
    public val sourceConnectionInfo: MySqlConnectionInfoResponse,
    public val targetConnectionInfo: MySqlConnectionInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlSyncTaskInputResponse): MigrateMySqlAzureDbForMySqlSyncTaskInputResponse =
            MigrateMySqlAzureDbForMySqlSyncTaskInputResponse(
                selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse.Companion.toKotlin(args0)
                    })
                }),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
