@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appliedChanges Number of applied changes
 * @property cdcDeleteCounter Number of cdc deletes
 * @property cdcInsertCounter Number of cdc inserts
 * @property cdcUpdateCounter Number of cdc updates
 * @property databaseName Name of the database
 * @property endedOn Migration end time
 * @property fullLoadCompletedTables Number of tables completed in full load
 * @property fullLoadErroredTables Number of tables errored in full load
 * @property fullLoadLoadingTables Number of tables loading in full load
 * @property fullLoadQueuedTables Number of tables queued in full load
 * @property id Result identifier
 * @property incomingChanges Number of incoming changes
 * @property initializationCompleted Indicates if initial load (full load) has been completed
 * @property latency CDC apply latency
 * @property migrationState Migration state that this database is in
 * @property resultType Result type
 * Expected value is 'DatabaseLevelOutput'.
 * @property startedOn Migration start time
 */
public data class MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevelResponse(
    public val appliedChanges: Double,
    public val cdcDeleteCounter: Double,
    public val cdcInsertCounter: Double,
    public val cdcUpdateCounter: Double,
    public val databaseName: String,
    public val endedOn: String,
    public val fullLoadCompletedTables: Double,
    public val fullLoadErroredTables: Double,
    public val fullLoadLoadingTables: Double,
    public val fullLoadQueuedTables: Double,
    public val id: String,
    public val incomingChanges: Double,
    public val initializationCompleted: Boolean,
    public val latency: Double,
    public val migrationState: String,
    public val resultType: String,
    public val startedOn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevelResponse): MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevelResponse =
            MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevelResponse(
                appliedChanges = javaType.appliedChanges(),
                cdcDeleteCounter = javaType.cdcDeleteCounter(),
                cdcInsertCounter = javaType.cdcInsertCounter(),
                cdcUpdateCounter = javaType.cdcUpdateCounter(),
                databaseName = javaType.databaseName(),
                endedOn = javaType.endedOn(),
                fullLoadCompletedTables = javaType.fullLoadCompletedTables(),
                fullLoadErroredTables = javaType.fullLoadErroredTables(),
                fullLoadLoadingTables = javaType.fullLoadLoadingTables(),
                fullLoadQueuedTables = javaType.fullLoadQueuedTables(),
                id = javaType.id(),
                incomingChanges = javaType.incomingChanges(),
                initializationCompleted = javaType.initializationCompleted(),
                latency = javaType.latency(),
                migrationState = javaType.migrationState(),
                resultType = javaType.resultType(),
                startedOn = javaType.startedOn(),
            )
    }
}
