@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs
 * @property migrationSetting Migration settings which tune the migration behavior
 * @property name Name of the database
 * @property selectedTables Tables selected for migration
 * @property sourceSetting Source settings to tune source endpoint migration behavior
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 * @property targetSetting Target settings to tune target endpoint migration behavior
 */
public data class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse(
    public val migrationSetting: Map<String, String>? = null,
    public val name: String? = null,
    public val selectedTables: List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputResponse>? = null,
    public val sourceSetting: Map<String, String>? = null,
    public val targetDatabaseName: String? = null,
    public val targetSetting: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse): MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse =
            MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse(
                migrationSetting = javaType.migrationSetting().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                selectedTables = javaType.selectedTables().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputResponse.Companion.toKotlin(args0)
                    })
                }),
                sourceSetting = javaType.sourceSetting().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                targetDatabaseName = javaType.targetDatabaseName().map({ args0 -> args0 }).orElse(null),
                targetSetting = javaType.targetSetting().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
