@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endedOn Migration end time
 * @property id Result identifier
 * @property resultType Result type
 * Expected value is 'MigrationLevelOutput'.
 * @property sourceServer Source server name
 * @property sourceServerType Source server type.
 * @property sourceServerVersion Source server version
 * @property startedOn Migration start time
 * @property state Migration status
 * @property targetServer Target server name
 * @property targetServerType Target server type.
 * @property targetServerVersion Target server version
 */
public data class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse(
    public val endedOn: String,
    public val id: String,
    public val resultType: String,
    public val sourceServer: String,
    public val sourceServerType: String,
    public val sourceServerVersion: String,
    public val startedOn: String,
    public val state: String,
    public val targetServer: String,
    public val targetServerType: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse): MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse =
            MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse(
                endedOn = javaType.endedOn(),
                id = javaType.id(),
                resultType = javaType.resultType(),
                sourceServer = javaType.sourceServer(),
                sourceServerType = javaType.sourceServerType(),
                sourceServerVersion = javaType.sourceServerVersion(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
                targetServer = javaType.targetServer(),
                targetServerType = javaType.targetServerType(),
                targetServerVersion = javaType.targetServerVersion(),
            )
    }
}
