@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 * @property validationOptions Validation options
 */
public data class MigrateSqlServerSqlDbSyncTaskInputResponse(
    public val selectedDatabases: List<MigrateSqlServerSqlDbSyncDatabaseInputResponse>,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
    public val validationOptions: MigrationValidationOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlDbSyncTaskInputResponse): MigrateSqlServerSqlDbSyncTaskInputResponse = MigrateSqlServerSqlDbSyncTaskInputResponse(
            selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSqlServerSqlDbSyncDatabaseInputResponse.Companion.toKotlin(args0)
                })
            }),
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            validationOptions = javaType.validationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrationValidationOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
