@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 * @property validationOptions Options for enabling various post migration validations. Available options,
 *  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
 *  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
 */
public data class MigrateSqlServerSqlDbTaskInputResponse(
    public val selectedDatabases: List<MigrateSqlServerSqlDbDatabaseInputResponse>,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
    public val validationOptions: MigrationValidationOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlDbTaskInputResponse): MigrateSqlServerSqlDbTaskInputResponse = MigrateSqlServerSqlDbTaskInputResponse(
            selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSqlServerSqlDbDatabaseInputResponse.Companion.toKotlin(args0)
                })
            }),
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            validationOptions = javaType.validationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrationValidationOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
