@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property id Migration validation result identifier
 * @property migrationId Migration Identifier
 * @property resultType Result type
 * Expected value is 'MigrationValidationOutput'.
 * @property status Current status of validation at the migration level. Status from the database validation result status will be aggregated here.
 * @property summaryResults Validation summary results for each database
 */
public data class MigrateSqlServerSqlDbTaskOutputValidationResultResponse(
    public val id: String,
    public val migrationId: String,
    public val resultType: String,
    public val status: String,
    public val summaryResults: Map<String, MigrationValidationDatabaseSummaryResultResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlDbTaskOutputValidationResultResponse): MigrateSqlServerSqlDbTaskOutputValidationResultResponse =
            MigrateSqlServerSqlDbTaskOutputValidationResultResponse(
                id = javaType.id(),
                migrationId = javaType.migrationId(),
                resultType = javaType.resultType(),
                status = javaType.status(),
                summaryResults = javaType.summaryResults().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.MigrationValidationDatabaseSummaryResultResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
            )
    }
}
