@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
 * @property backupFilePaths The list of backup files to be used in case of existing backups.
 * @property backupFileShare Backup file share information for backing up this database.
 * @property name Name of the database
 * @property restoreDatabaseName Name of the database at destination
 */
public data class MigrateSqlServerSqlMIDatabaseInputResponse(
    public val backupFilePaths: List<String>? = null,
    public val backupFileShare: FileShareResponse? = null,
    public val name: String,
    public val restoreDatabaseName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMIDatabaseInputResponse): MigrateSqlServerSqlMIDatabaseInputResponse = MigrateSqlServerSqlMIDatabaseInputResponse(
            backupFilePaths = javaType.backupFilePaths().map({ args0 -> args0 }),
            backupFileShare = javaType.backupFileShare().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.FileShareResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            restoreDatabaseName = javaType.restoreDatabaseName(),
        )
    }
}
