@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endedOn Migration end time
 * @property exceptionsAndWarnings Migration errors and warnings per job
 * @property id Result identifier
 * @property isEnabled The state of the original Agent Job.
 * @property message Migration progress message
 * @property name Agent Job name.
 * @property resultType Result type
 * Expected value is 'AgentJobLevelOutput'.
 * @property startedOn Migration start time
 * @property state Current state of migration
 */
public data class MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse(
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val isEnabled: Boolean,
    public val message: String,
    public val name: String,
    public val resultType: String,
    public val startedOn: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse): MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse =
            MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse(
                endedOn = javaType.endedOn(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                isEnabled = javaType.isEnabled(),
                message = javaType.message(),
                name = javaType.name(),
                resultType = javaType.resultType(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
            )
    }
}
