@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property agentJobs Selected agent jobs as a map from name to id
 * @property databases Selected databases as a map from database name to database id
 * @property endedOn Migration end time
 * @property exceptionsAndWarnings Migration exceptions and warnings.
 * @property id Result identifier
 * @property logins Selected logins as a map from name to id
 * @property message Migration progress message
 * @property orphanedUsersInfo List of orphaned users.
 * @property resultType Result type
 * Expected value is 'MigrationLevelOutput'.
 * @property serverRoleResults Map of server role migration results.
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerVersion Source server version
 * @property startedOn Migration start time
 * @property state Current state of migration
 * @property status Current status of migration
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Target server version
 */
public data class MigrateSqlServerSqlMITaskOutputMigrationLevelResponse(
    public val agentJobs: Map<String, String>,
    public val databases: Map<String, String>,
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val logins: Map<String, String>,
    public val message: String,
    public val orphanedUsersInfo: List<OrphanedUserInfoResponse>,
    public val resultType: String,
    public val serverRoleResults: Map<String, StartMigrationScenarioServerRoleResultResponse>,
    public val sourceServerBrandVersion: String,
    public val sourceServerVersion: String,
    public val startedOn: String,
    public val state: String,
    public val status: String,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMITaskOutputMigrationLevelResponse): MigrateSqlServerSqlMITaskOutputMigrationLevelResponse =
            MigrateSqlServerSqlMITaskOutputMigrationLevelResponse(
                agentJobs = javaType.agentJobs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                databases = javaType.databases().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                endedOn = javaType.endedOn(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                logins = javaType.logins().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                message = javaType.message(),
                orphanedUsersInfo = javaType.orphanedUsersInfo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.OrphanedUserInfoResponse.Companion.toKotlin(args0)
                    })
                }),
                resultType = javaType.resultType(),
                serverRoleResults = javaType.serverRoleResults().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.StartMigrationScenarioServerRoleResultResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
                sourceServerVersion = javaType.sourceServerVersion(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
                status = javaType.status(),
                targetServerBrandVersion = javaType.targetServerBrandVersion(),
                targetServerVersion = javaType.targetServerVersion(),
            )
    }
}
