@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for command that completes sync migration for a database.
 * @property errors List of errors that happened during the command execution
 * @property id Result identifier
 */
public data class MigrateSyncCompleteCommandOutputResponse(
    public val errors: List<ReportableExceptionResponse>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSyncCompleteCommandOutputResponse): MigrateSyncCompleteCommandOutputResponse = MigrateSyncCompleteCommandOutputResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
