@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Migration Validation Database level summary result
 * @property endedOn Validation end time
 * @property id Result identifier
 * @property migrationId Migration Identifier
 * @property sourceDatabaseName Name of the source database
 * @property startedOn Validation start time
 * @property status Current status of validation at the database level
 * @property targetDatabaseName Name of the target database
 */
public data class MigrationValidationDatabaseSummaryResultResponse(
    public val endedOn: String,
    public val id: String,
    public val migrationId: String,
    public val sourceDatabaseName: String,
    public val startedOn: String,
    public val status: String,
    public val targetDatabaseName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrationValidationDatabaseSummaryResultResponse): MigrationValidationDatabaseSummaryResultResponse =
            MigrationValidationDatabaseSummaryResultResponse(
                endedOn = javaType.endedOn(),
                id = javaType.id(),
                migrationId = javaType.migrationId(),
                sourceDatabaseName = javaType.sourceDatabaseName(),
                startedOn = javaType.startedOn(),
                status = javaType.status(),
                targetDatabaseName = javaType.targetDatabaseName(),
            )
    }
}
