@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Types of validations to run after the migration
 * @property enableDataIntegrityValidation Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
 * @property enableQueryAnalysisValidation Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
 * @property enableSchemaValidation Allows to compare the schema information between source and target.
 */
public data class MigrationValidationOptionsResponse(
    public val enableDataIntegrityValidation: Boolean? = null,
    public val enableQueryAnalysisValidation: Boolean? = null,
    public val enableSchemaValidation: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrationValidationOptionsResponse): MigrationValidationOptionsResponse = MigrationValidationOptionsResponse(
            enableDataIntegrityValidation = javaType.enableDataIntegrityValidation().map({ args0 ->
                args0
            }).orElse(null),
            enableQueryAnalysisValidation = javaType.enableQueryAnalysisValidation().map({ args0 ->
                args0
            }).orElse(null),
            enableSchemaValidation = javaType.enableSchemaValidation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
