@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a MongoDB data source
 * @property databases A list of non-system databases in the cluster
 * @property supportsSharding Whether the cluster supports sharded collections
 * @property type The type of data source
 * @property version The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if Type is BlobContainer.
 */
public data class MongoDbClusterInfoResponse(
    public val databases: List<MongoDbDatabaseInfoResponse>,
    public val supportsSharding: Boolean,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbClusterInfoResponse): MongoDbClusterInfoResponse = MongoDbClusterInfoResponse(
            databases = javaType.databases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbDatabaseInfoResponse.Companion.toKotlin(args0)
                })
            }),
            supportsSharding = javaType.supportsSharding(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
