@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes a supported collection within a MongoDB database
 * @property averageDocumentSize The average document size, or -1 if the average size is unknown
 * @property dataSize The estimated total data size, in bytes, or -1 if the size is unknown.
 * @property databaseName The name of the database containing the collection
 * @property documentCount The estimated total number of documents, or -1 if the document count is unknown
 * @property isCapped Whether the collection is a capped collection (i.e. whether it has a fixed size and acts like a circular buffer)
 * @property isSystemCollection Whether the collection is system collection
 * @property isView Whether the collection is a view of another collection
 * @property name The unqualified name of the database or collection
 * @property qualifiedName The qualified name of the database or collection. For a collection, this is the database-qualified name.
 * @property shardKey The shard key on the collection, or null if the collection is not sharded
 * @property supportsSharding Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if necessary.
 * @property viewOf The name of the collection that this is a view of, if IsView is true
 */
public data class MongoDbCollectionInfoResponse(
    public val averageDocumentSize: Double,
    public val dataSize: Double,
    public val databaseName: String,
    public val documentCount: Double,
    public val isCapped: Boolean,
    public val isSystemCollection: Boolean,
    public val isView: Boolean,
    public val name: String,
    public val qualifiedName: String,
    public val shardKey: MongoDbShardKeyInfoResponse? = null,
    public val supportsSharding: Boolean,
    public val viewOf: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbCollectionInfoResponse): MongoDbCollectionInfoResponse = MongoDbCollectionInfoResponse(
            averageDocumentSize = javaType.averageDocumentSize(),
            dataSize = javaType.dataSize(),
            databaseName = javaType.databaseName(),
            documentCount = javaType.documentCount(),
            isCapped = javaType.isCapped(),
            isSystemCollection = javaType.isSystemCollection(),
            isView = javaType.isView(),
            name = javaType.name(),
            qualifiedName = javaType.qualifiedName(),
            shardKey = javaType.shardKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbShardKeyInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportsSharding = javaType.supportsSharding(),
            viewOf = javaType.viewOf().map({ args0 -> args0 }).orElse(null),
        )
    }
}
