@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Describes how an individual MongoDB collection should be migrated
 * @property canDelete Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
 * @property shardKey Describes a MongoDB shard key
 * @property targetRUs The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
 */
public data class MongoDbCollectionSettingsResponse(
    public val canDelete: Boolean? = null,
    public val shardKey: MongoDbShardKeySettingResponse? = null,
    public val targetRUs: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbCollectionSettingsResponse): MongoDbCollectionSettingsResponse = MongoDbCollectionSettingsResponse(
            canDelete = javaType.canDelete().map({ args0 -> args0 }).orElse(null),
            shardKey = javaType.shardKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbShardKeySettingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetRUs = javaType.targetRUs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
