@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a connection to a MongoDB data source
 * @property connectionString A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
 * @property password Password credential.
 * @property type Type of connection info
 * Expected value is 'MongoDbConnectionInfo'.
 * @property userName User name
 */
public data class MongoDbConnectionInfoResponse(
    public val connectionString: String,
    public val password: String? = null,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbConnectionInfoResponse): MongoDbConnectionInfoResponse = MongoDbConnectionInfoResponse(
            connectionString = javaType.connectionString(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
