@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a database within a MongoDB data source
 * @property averageDocumentSize The average document size, or -1 if the average size is unknown
 * @property collections A list of supported collections in a MongoDB database
 * @property dataSize The estimated total data size, in bytes, or -1 if the size is unknown.
 * @property documentCount The estimated total number of documents, or -1 if the document count is unknown
 * @property name The unqualified name of the database or collection
 * @property qualifiedName The qualified name of the database or collection. For a collection, this is the database-qualified name.
 * @property supportsSharding Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if necessary.
 */
public data class MongoDbDatabaseInfoResponse(
    public val averageDocumentSize: Double,
    public val collections: List<MongoDbCollectionInfoResponse>,
    public val dataSize: Double,
    public val documentCount: Double,
    public val name: String,
    public val qualifiedName: String,
    public val supportsSharding: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbDatabaseInfoResponse): MongoDbDatabaseInfoResponse = MongoDbDatabaseInfoResponse(
            averageDocumentSize = javaType.averageDocumentSize(),
            collections = javaType.collections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbCollectionInfoResponse.Companion.toKotlin(args0)
                })
            }),
            dataSize = javaType.dataSize(),
            documentCount = javaType.documentCount(),
            name = javaType.name(),
            qualifiedName = javaType.qualifiedName(),
            supportsSharding = javaType.supportsSharding(),
        )
    }
}
