@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes the progress of the overall migration
 * @property bytesCopied The number of document bytes copied during the Copying stage
 * @property databases The progress of the databases in the migration. The keys are the names of the databases
 * @property documentsCopied The number of documents copied during the Copying stage
 * @property elapsedTime The elapsed time in the format [ddd&#46;]hh:mm:ss[&#46;fffffff] (i.e. TimeSpan format)
 * @property errors The errors and warnings that have occurred for the current object. The keys are the error codes.
 * @property eventsPending The number of oplog events awaiting replay
 * @property eventsReplayed The number of oplog events replayed so far
 * @property lastEventTime The timestamp of the last oplog event received, or null if no oplog event has been received yet
 * @property lastReplayTime The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
 * @property name The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null.
 * @property qualifiedName The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null.
 * @property resultType The type of progress object
 * Expected value is 'Migration'.
 * @property state
 * @property totalBytes The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown
 * @property totalDocuments The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown
 */
public data class MongoDbMigrationProgressResponse(
    public val bytesCopied: Double,
    public val databases: Map<String, MongoDbDatabaseProgressResponse>? = null,
    public val documentsCopied: Double,
    public val elapsedTime: String,
    public val errors: Map<String, MongoDbErrorResponse>,
    public val eventsPending: Double,
    public val eventsReplayed: Double,
    public val lastEventTime: String? = null,
    public val lastReplayTime: String? = null,
    public val name: String? = null,
    public val qualifiedName: String? = null,
    public val resultType: String,
    public val state: String,
    public val totalBytes: Double,
    public val totalDocuments: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbMigrationProgressResponse): MongoDbMigrationProgressResponse = MongoDbMigrationProgressResponse(
            bytesCopied = javaType.bytesCopied(),
            databases = javaType.databases().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbDatabaseProgressResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            documentsCopied = javaType.documentsCopied(),
            elapsedTime = javaType.elapsedTime(),
            errors = javaType.errors().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbErrorResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            eventsPending = javaType.eventsPending(),
            eventsReplayed = javaType.eventsReplayed(),
            lastEventTime = javaType.lastEventTime().map({ args0 -> args0 }).orElse(null),
            lastReplayTime = javaType.lastReplayTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            qualifiedName = javaType.qualifiedName().map({ args0 -> args0 }).orElse(null),
            resultType = javaType.resultType(),
            state = javaType.state(),
            totalBytes = javaType.totalBytes(),
            totalDocuments = javaType.totalDocuments(),
        )
    }
}
