@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Mongo source and target database and collection details.
 * @property migrationProgressDetails Detailed migration status. Not included by default.
 * @property sourceCollection Source collection name.
 * @property sourceDatabase Source database name.
 * @property targetCollection Target collection name.
 * @property targetDatabase Target database name.
 */
public data class MongoMigrationCollectionResponse(
    public val migrationProgressDetails: MongoMigrationProgressDetailsResponse,
    public val sourceCollection: String? = null,
    public val sourceDatabase: String? = null,
    public val targetCollection: String? = null,
    public val targetDatabase: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoMigrationCollectionResponse): MongoMigrationCollectionResponse = MongoMigrationCollectionResponse(
            migrationProgressDetails = javaType.migrationProgressDetails().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.MongoMigrationProgressDetailsResponse.Companion.toKotlin(args0)
            }),
            sourceCollection = javaType.sourceCollection().map({ args0 -> args0 }).orElse(null),
            sourceDatabase = javaType.sourceDatabase().map({ args0 -> args0 }).orElse(null),
            targetCollection = javaType.targetCollection().map({ args0 -> args0 }).orElse(null),
            targetDatabase = javaType.targetDatabase().map({ args0 -> args0 }).orElse(null),
        )
    }
}
