@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Error information in OData format.
 * @property code The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
 * @property details Inner errors that caused this error
 * @property message The human-readable description of the error
 */
public data class ODataErrorResponse(
    public val code: String? = null,
    public val details: List<ODataErrorResponse>? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ODataErrorResponse): ODataErrorResponse = ODataErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ODataErrorResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
