@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information for connecting to Oracle server
 * @property dataSource EZConnect or TNSName connection string.
 * @property password Password credential.
 * @property type Type of connection info
 * Expected value is 'OracleConnectionInfo'.
 * @property userName User name
 */
public data class OracleConnectionInfoResponse(
    public val dataSource: String,
    public val password: String? = null,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.OracleConnectionInfoResponse): OracleConnectionInfoResponse = OracleConnectionInfoResponse(
            dataSource = javaType.dataSource(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
