@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Information for connecting to PostgreSQL server
 * @property databaseName Name of the database
 * @property encryptConnection Whether to encrypt the connection
 * @property password Password credential.
 * @property port Port for Server
 * @property serverName Name of the server
 * @property trustServerCertificate Whether to trust the server certificate
 * @property type Type of connection info
 * Expected value is 'PostgreSqlConnectionInfo'.
 * @property userName User name
 */
public data class PostgreSqlConnectionInfoResponse(
    public val databaseName: String? = null,
    public val encryptConnection: Boolean? = null,
    public val password: String? = null,
    public val port: Int,
    public val serverName: String,
    public val trustServerCertificate: Boolean? = null,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.PostgreSqlConnectionInfoResponse): PostgreSqlConnectionInfoResponse = PostgreSqlConnectionInfoResponse(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            encryptConnection = javaType.encryptConnection().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            serverName = javaType.serverName(),
            trustServerCertificate = javaType.trustServerCertificate().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
