@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Results for query analysis comparison between the source and target
 * @property queryResults List of queries executed and it's execution results in source and target
 * @property validationErrors Errors that are part of the execution
 */
public data class QueryAnalysisValidationResultResponse(
    public val queryResults: QueryExecutionResultResponse? = null,
    public val validationErrors: ValidationErrorResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.QueryAnalysisValidationResultResponse): QueryAnalysisValidationResultResponse = QueryAnalysisValidationResultResponse(
            queryResults = javaType.queryResults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.QueryExecutionResultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ValidationErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
