@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Exception object for all custom exceptions
 * @property actionableMessage Actionable steps for this exception
 * @property filePath The path to the file where exception occurred
 * @property hResult Coded numerical value that is assigned to a specific exception
 * @property lineNumber The line number where exception occurred
 * @property message Error message
 * @property stackTrace Stack trace
 */
public data class ReportableExceptionResponse(
    public val actionableMessage: String? = null,
    public val filePath: String? = null,
    public val hResult: Int? = null,
    public val lineNumber: String? = null,
    public val message: String? = null,
    public val stackTrace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ReportableExceptionResponse): ReportableExceptionResponse = ReportableExceptionResponse(
            actionableMessage = javaType.actionableMessage().map({ args0 -> args0 }).orElse(null),
            filePath = javaType.filePath().map({ args0 -> args0 }).orElse(null),
            hResult = javaType.hResult().map({ args0 -> args0 }).orElse(null),
            lineNumber = javaType.lineNumber().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            stackTrace = javaType.stackTrace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
